//121013 Driver for 2nd silicon LTC2374 family of 8ch SAR ADCs with SOS bit
//GMH
`timescale 1ps / 1ps
module RevA
(
	CSB_33,
	CLK,
	CLKOUT,
	SDO,
	SCK_33,
	BUSY_33,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB14,
	DB15,
	DB16,
	DB17,
	DB0,
	DB1,
	DB11,
	DB12,
	DB13,
	WRIN,
	WRIN2,
	WRIN2_OUT,
	B16_18L,
	SCK_IN,
	SCK_OUT,
	SDI_33,
	SDIIN,
	SCKIN,
	CNVIN,
	ID,
	SOS,
	A3,
	A2,
	A1,
	A0,
	R1,
	R0,
	SEL,
	d_latch_out,
	master_clk_out,
	master_clkd_out,
	counter
);
output 			d_latch_out;
output			master_clk_out;
output			master_clkd_out;
output			SOS;											//start of sequence bit 1 for first data in sequence
output			A3;											//
output			A2;											// A3-A0 give PScope address info on last ADC conversion
output			A1;											//
output			A0;											//
output			R1;											// R1-R0 give PScope Range info on last ADC conversion
output			R0;											//
output			SEL;											// SEL gives PScope DGC info on last ADC conversion
output			CSB_33;										// CSB_33 is unsynchronized CONV signal. 
input				ID;											// ID is pulled low by daughter board if used.
input          WRIN;											//if WRIN=1 CPLD controls ADC, if WRIN=0 sneakerport controls ADC
input 			WRIN2;										//if WRIN2=0 sneaker port active if WRIN2=1 sneaker port inactive
output			WRIN2_OUT;
input				SDIIN;										//Not used at present \
input				SCKIN;										//Not used at present  | Possibly use these to bypass NC7SZ66
input				CNVIN;										//Not used at present /
input				CLK;											//Clock from DC2071 Clock is divided by 100 to set conv rate
output			CLKOUT;										//CLKOUT to PScope at conv rate
input				SDO;											//SDO from LTC2374
output			SCK_33;										//SCK to LTC2374
output       	SDI_33;										//SDI to LTC2374
input       	SCK_IN;										//SCK_IN delayed SCK
output      	SCK_OUT;										//SCK_OUT dummy signal
input				BUSY_33;										//BUSY from LTC2374
output			DB2;											//
output			DB3;											//
output			DB4;											//
output			DB5;											//
output			DB6;											//
output			DB7;											//
output			DB8;											  //
output			DB9;											   //
output			DB10;												 //DB0-DB17 parallel data from LTC2374
output			DB14;											   //
output			DB15;											  //
output			DB16;											//
output			DB17;											//
output			DB0;											//
output			DB1;											//
output			DB11;											//
output			DB12;											//
output			DB13;											//
output[7:0]    counter;
wire [7:0]     counter;
wire [7:0]	   delay;
assign counter = delay;
input				B16_18L;										//16bit/18bit detect 1=16 0=18
parameter 		CLR = 1'b0,
					SET = 1'b1,
					op = 1'b1,
					ip = 1'b0;	
wire master_clk;												//same as CLK
wire [25:0] dout;
wire mosi;
wire aux0;
wire conv;
wire sck;
wire B34;
wire B30;
wire data_latch;
//wire data_latchl /* synthesis keep */;											
//wire data_latcha /* synthesis keep */;											
wire master_clk_0 /* synthesis keep */;				//increase CNVSTL pulse to 20ns
wire master_clk_1 /* synthesis keep */;
wire master_clk_2 /* synthesis keep */;
wire master_clk_3 /* synthesis keep */;
wire master_clk_4 /* synthesis keep */;
wire master_clk_5 /* synthesis keep */;
wire master_clk_6 /* synthesis keep */;
wire master_clk_7 /* synthesis keep */;
wire master_clk_8 /* synthesis keep */;
wire master_clk_9 /* synthesis keep */;
/*reg master_out_0; //preserve
reg master_out_1; //preserve
reg master_out_2; //preserve
reg master_out_3; //preserve
reg master_out_4; //preserve
reg master_out_5; //preserve
reg master_out_6; //preserve
reg master_out_7; //preserve
reg master_out_8; //preserve
reg master_out_9; //preserve */
wire master_clk_10 /* synthesis keep */;										
wire master_clk_11 /* synthesis keep */;
wire master_clk_12 /* synthesis keep */;
wire master_clk_13 /* synthesis keep */;
wire master_clk_14 /* synthesis keep */;
wire master_clk_15 /* synthesis keep */;
wire master_clk_16 /* synthesis keep */;
wire master_clk_17 /* synthesis keep */;
wire master_clk_18 /* synthesis keep */;
wire master_clk_19 /* synthesis keep */;
/*reg master_out_10; //preserve
reg master_out_11; //preserve
reg master_out_12; //preserve
reg master_out_13; //preserve
reg master_out_14; //preserve
reg master_out_15; //preserve
reg master_out_16; //preserve
reg master_out_17; //preserve
reg master_out_18; //preserve
reg master_out_19; //preserve */

wire miso;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
reg DB12;
reg DB13;
reg DB14;
reg DB15;
reg DB16;
reg DB17;
reg SOS;
reg A3;
reg A2;
reg A1;
reg A0;
reg R1;
reg R0;
reg SEL;														
wire BUSY_33;
wire CLKOUT;
reg clkdiv2;
wire clkout_latch;																	
wire d_latch;
wire B16_18L;
wire ID;
																			
wire SCK_IN;
wire SCK_OUT;
wire numbits;

assign numbits = B16_18L;									//use to set data direction and pin assignments 1=16bits 0=18bits
assign SCK_OUT = SCK_IN | SCKIN | SDIIN | CNVIN;
//assign IDOUT = ID;
    always @(posedge d_latch )begin//	 		           //12/03/13 was negedge								      					    														
				if (numbits==1) begin////
					DB15 <= dout[23];
					DB14 <= dout[22];
					DB13 <= dout[21];
					DB12 <= dout[20];
					DB11 <= dout[19];
					DB10 <= dout[18];
					DB9 <= dout[17];
					DB8 <= dout[16];
					DB7 <= dout[15];
					DB6 <= dout[14];
					DB5 <= dout[13];
					DB4 <= dout[12];
					DB3 <= dout[11];
					DB2 <= dout[10];
					DB1 <= dout[9];
					DB0 <= dout[8];
					SOS <= dout[7];
					A3 <= dout[6];
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					R1 <= dout[2];
					R0 <= dout[1];
					SEL <= dout[0];
					DB17 <= 0;
					DB16 <= 0;									// 16bit
				end////	    
				else begin////
					DB17 <= dout[25];
					DB16 <= dout[24];
					DB15 <= dout[23];
					DB14 <= dout[22];
					DB13 <= dout[21];
					DB12 <= dout[20];
					DB11 <= dout[19];
					DB10 <= dout[18];
					DB9 <= dout[17];
					DB8 <= dout[16];
					DB7 <= dout[15];
					DB6 <= dout[14];
					DB5 <= dout[13];
					DB4 <= dout[12];
					DB3 <= dout[11];
					DB2 <= dout[10];
					DB1 <= dout[9];
					DB0 <= dout[8];					// 18bit
					SOS <= dout[7];
					A3 <= dout[6];
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					R1 <= dout[2];
					R0 <= dout[1];
					SEL <= dout[0];
				end////
    end//
	 


   
assign master_clk = CLK & WRIN;						  			//CLK active when WRIN is high. was WRIN
assign master_clk_0 = ~master_clk;
assign master_clk_1 = ~master_clk_0;
assign master_clk_2 = ~master_clk_1;
assign master_clk_3 = ~master_clk_2;
assign master_clk_4 = ~master_clk_3;
assign master_clk_5 = ~master_clk_4;
assign master_clk_6 = ~master_clk_5;
assign master_clk_7 = ~master_clk_6;
assign master_clk_8 = ~master_clk_7;
assign master_clk_9 = ~master_clk_8;

assign master_clk_10 = ~master_clk_9;
assign master_clk_11 = ~master_clk_10;
assign master_clk_12 = ~master_clk_11;
assign master_clk_13 = ~master_clk_12;
assign master_clk_14 = ~master_clk_13;
assign master_clk_15 = ~master_clk_14;
assign master_clk_16 = ~master_clk_15;
assign master_clk_17 = ~master_clk_16;
assign master_clk_18 = ~master_clk_17;
assign master_clk_19 = ~master_clk_18;

assign miso = SDO;
assign WRIN2_OUT = WRIN2;
assign CSB_33 = ~conv ;					
assign d_latch = data_latch ;	
assign d_latch_out = data_latch;
assign master_clk_out = master_clk;	
assign master_clkd_out = master_clk_15;							
assign CLKOUT =  data_latch ;											//12/3/13 was BUSY_33

/*dff dff1(.d(0), .clk(CLK), .clrn(1), .prn(~data_latch), .q(clkout_latch));
dff dffmc0(.d(0), .clk(master_clk_0), .clrn(1), .prn(1), .q(master_out_0));
dff dffmc1(.d(0), .clk(master_clk_1), .clrn(1), .prn(1), .q(master_out_1));
dff dffmc2(.d(0), .clk(master_clk_2), .clrn(1), .prn(1), .q(master_out_2));
dff dffmc3(.d(0), .clk(master_clk_3), .clrn(1), .prn(1), .q(master_out_3));
dff dffmc4(.d(0), .clk(master_clk_4), .clrn(1), .prn(1), .q(master_out_4));
dff dffmc5(.d(0), .clk(master_clk_5), .clrn(1), .prn(1), .q(master_out_5));
dff dffmc6(.d(0), .clk(master_clk_6), .clrn(1), .prn(1), .q(master_out_6));
dff dffmc7(.d(0), .clk(master_clk_7), .clrn(1), .prn(1), .q(master_out_7));
dff dffmc8(.d(0), .clk(master_clk_8), .clrn(1), .prn(1), .q(master_out_8));
dff dffmc9(.d(0), .clk(master_clk_9), .clrn(1), .prn(1), .q(master_out_9));

dff dffmc10(.d(0), .clk(master_clk_10), .clrn(1), .prn(1), .q(master_out_10));
dff dffmc11(.d(0), .clk(master_clk_11), .clrn(1), .prn(1), .q(master_out_11));
dff dffmc12(.d(0), .clk(master_clk_12), .clrn(1), .prn(1), .q(master_out_12));
dff dffmc13(.d(0), .clk(master_clk_13), .clrn(1), .prn(1), .q(master_out_13));
dff dffmc14(.d(0), .clk(master_clk_14), .clrn(1), .prn(1), .q(master_out_14));
dff dffmc15(.d(0), .clk(master_clk_15), .clrn(1), .prn(1), .q(master_out_15));
dff dffmc16(.d(0), .clk(master_clk_16), .clrn(1), .prn(1), .q(master_out_16));
dff dffmc17(.d(0), .clk(master_clk_17), .clrn(1), .prn(1), .q(master_out_17));
dff dffmc18(.d(0), .clk(master_clk_18), .clrn(1), .prn(1), .q(master_out_18));
dff dffmc19(.d(1'b0), .clk(master_clk_19), .clrn(1'b1), .prn(1'b1), .q(master_out_19)); */
									
serial_io io_2(.master_clk	(master_clk_1),	   			//clk in from DC2071
			.mosi	 	   	(mosi), 	   	   				//sdi to DUT not used for all parts
			.miso	 	   	(miso), 	   	   				//sdo from DUT	
			.data_latch		(data_latch), 						//when to grab data
			.sck		 		(sck),		   					//sck to DUT 
			.conv	 	   	(conv),		   					//conv or conv_gate to DUT
			.aux0	 	   	(aux0), 		   					//aux signal not used for all parts
			.dout	 	   	(dout),								//parallel data bits
			.mcd				(master_clk),						//delayed version of master_clk //5/2/13 was master_clk_15
			.B16_18L			(B16_18L),							//16-bit/18-bit select
			.WRIN				(WRIN),
			.delay   		(delay)
			);

 maxii_io															//primitive for MAXII IO pin
 d_bit_34(.datain  	(sck),									//serial_clk_out to ADC
          .oe  		(WRIN),									//WRIN=1 SCK_33=sck, WRIN=0 SCK_33=HiZ
          .padio  	(SCK_33),								//IO pin
          .combout 	(B34));									//
 defparam d_bit_34.operation_mode = "bidir";
 
 maxii_io															//primitive for MAXII IO pin
 d_bit_30(.datain  (mosi),										//master_out_slave_in (to ADC SDI pin)
         .oe  (WRIN),											//WRIN=1 SDI_33=sdi, WRIN=0 SDI_33=HiZ
         .padio  (SDI_33),										//IO pin
         .combout (B30));										//
 defparam d_bit_30.operation_mode = "bidir";
 

endmodule
